<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AiMessage extends Model
{
    protected $table = 'ai_messages';

    protected $fillable = [
        'user_id',
        'business_id',
        'supplier_id',
        'scope',       // business | supplier | your | user
        'intent',      // purchases | sales | general
        'time_label',  // Today | This Week | This Month | Last Month | This Year | This Year (YTD) | Last Year
        'normalized_query',
        'question',
        'answer',
        'ok',          // 1 ok, 0 error/empty
    ];

    public function user()
    {
        return $this->belongsTo(\App\User::class, 'user_id');
    }
}

